function [KE,ME]=Elementmatrix(dx,dy,h)
nodes=[0 0;dx 0;dx dy;0 dy];
D=[1 0;0 1];
C=[1 0;0 1];
point=1/sqrt(3); 
gaussp(1,1)=-point;  gaussp(1,2)=-point; 
gaussp(2,1)=point;   gaussp(2,2)=-point; 
gaussp(3,1)=point;   gaussp(3,2)=point;
gaussp(4,1)=-point;  gaussp(4,2)=point; clear point
KE=0; 
ME=0;
for i=1:4
s=gaussp(i,1); t=gaussp(i,2);
J=[-(1-t) 1-t 1+t -(1+t);-(1-s) -(1+s) 1+s 1-s]/4*nodes;
B=inv(J)*[-(1-t) 1-t 1+t -(1+t);-(1-s) -(1+s) 1+s 1-s]/4; 
N=[(1-s)*(1-t) (1+s)*(1-t) (1+s)*(1+t) (1-s)*(1+t)]/4; 
NN=[N(1) N(2) N(3) N(4); N(1) N(2) N(3) N(4)]; clear N
KE=KE+B'*D*B*det(J)*h; clear B
ME=ME+NN'*C*NN*det(J)*h; clear NN
end
